 ; Ŀ
 ;   Crypt - cheapo encryption for paper output.                           
 ;   Copyright 2000 by Rocket Software                                     
 ;   Coming soon - harlecryption - encode data as a gothic romance novel.  
 ; 

 ; Ŀ
 ;   Splito - Split a text string in two, replacing alternate letters      
 ;   with spaces to make two complementary partial strings.                
 ;   Takes one argument, a text string, returns a list of two strings:     
 ;   "abcde" returns ("a c e" " b d ")                                     
 ;   Calls nothing.                                                        
 ; 
 (DEFUN SPLITO (str / pos 1or2 str1 str2 len)
  (setq pos 1)
  (setq 1or2 1)
  (setq str1 "")
  (setq str2 "")
  (setq len (strlen str))
  (while (and (<= pos len)
              (setq chra (substr str pos 1)))
         (if (= 1or2 1)
             (progn
                  (setq str1 (strcat str1 chra))
                  (setq str2 (strcat str2 " ")))
             (progn
                  (setq str1 (strcat str1 " "))
                  (setq str2 (strcat str2 chra))))
          (setq pos (1+ pos))
          (setq 1or2 (abs (1- 1or2))))
 (list str1 str2))
 ; Ŀ
 ;   Splito end.                                                           
 ; 

 ; Ŀ
 ;   Crypt.                                                                
 ; 
 (DEFUN C:CRYPT (/ filnam fn str strlis txlis1 txlis2 sty pa str ss styl)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Get an input file name.                                               
 ; 
  (if (and (/= 1 (setq filnam (getfiled "Input Text File" "" "" 0)))
           (setq fn (open filnam "r")))
      (progn
           (setq num 0)
 ; Ŀ
 ;   Split each line into two partial lines, store into lists.             
 ; 
           (while (setq str (read-line fn))
                  (grtext -2 (itoa (setq num (1+ num))))
                  (setq strlis (splito str))
                  (setq txlis1 (cons (car strlis) txlis1))
                  (setq txlis2 (cons (cadr strlis) txlis2)))
           (close fn)))
  (setq txlis1 (reverse txlis1))
  (setq txlis2 (reverse txlis2))
 ; Ŀ
 ;   Load the monospaced font, make it the current one.                    
 ; 
  (setq styl (getvar "textstyle"))
;  (command "style" "mono" "monotxt" "" "0.85" "" "" "" "")  ; acad font
  (command "style" "mono" "monos.ttf" "" "0.85" "" "" "")    ; truetype
 ; Ŀ
 ;   Make the first text column.                                           
 ; 
  (setq pa (getpoint "Start point: "))
  (setq pa (polar pa 0 2.5))
  (command ".text" pa 2.5 0)
  (command (car txlis1))
  (setq num 1)
  (while (setq str (nth num txlis1))
         (setq num (1+ num))
         (command ".text" "" str))
 ; Ŀ
 ;   And the second text column.                                           
 ; 
  (setq ss (ssadd))
  (command ".text" pa 2.5 0)
  (command (car txlis2))
  (ssadd (entlast) ss)
  (setq num 1)
  (while (setq str (nth num txlis2))
         (setq num (1+ num))
         (command ".text" "" str)
         (ssadd (entlast) ss))
 ; Ŀ
 ;   Mirror the last set of lines away from the first.                     
 ; 
  (setq pa (polar pa pi 2.5))
  (setvar "mirrtext" 1)
  (command ".mirror" ss "" pa (polar pa (/ pi 2) 10) "y")
 ; Ŀ
 ;   Reset and end.                                                        
 ; 
  (setvar "mirrtext" 0)
  (setvar "textstyle" styl)
 (princ))